<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Premium Plans with Feature Unlock</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #3B82F6;
            --success: #10B981;
            --danger: #EF4444;
            --dark: #1E293B;
            --light: #F8FAFC;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            transition: all 0.3s ease;
        }

        body {
            font-family: 'Segoe UI', system-ui, sans-serif;
            background: #F1F5F9;
            min-height: 100vh;
            padding: 2rem;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Plans Section */
        .plans-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin: 3rem 0;
        }

        .plan-card {
            background: white;
            border-radius: 1.5rem;
            padding: 2rem;
            text-align: center;
            box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1);
            cursor: pointer;
        }

        .plan-card:hover {
            transform: translateY(-5px);
        }

        .plan-icon {
            font-size: 2.5rem;
            color: var(--primary);
            margin-bottom: 1rem;
        }

        .price {
            font-size: 2.5rem;
            color: var(--dark);
            margin: 1rem 0;
            font-weight: 700;
        }

        .features-list {
            list-style: none;
            text-align: left;
            margin: 1.5rem 0;
            padding: 0 1rem;
        }

        .features-list li {
            margin: 0.5rem 0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .pay-button {
            background: var(--primary);
            color: white;
            border: none;
            padding: 1rem 2rem;
            border-radius: 2rem;
            cursor: pointer;
            font-size: 1rem;
            width: 100%;
            margin-top: 1rem;
        }

        .pay-button:hover {
            background: #2563EB;
        }

        /* Payment Section */
        .payment-section {
            display: none;
            flex-direction: column;
            align-items: center;
            gap: 2rem;
            margin-top: 2rem;
        }

        #qrCode {
            width: 250px;
            height: 250px;
            border: 3px solid var(--primary);
            border-radius: 1rem;
            padding: 1rem;
            background: white;
        }

        .payment-confirm {
            background: var(--success);
            color: white;
            padding: 1rem 2rem;
            border: none;
            border-radius: 2rem;
            cursor: pointer;
            margin-top: 1rem;
        }

        .back-button {
            background: var(--dark);
            color: white;
            padding: 1rem 2rem;
            border: none;
            border-radius: 2rem;
            cursor: pointer;
        }

        /* Unlocked Features */
        .unlocked-features {
            background: white;
            padding: 2rem;
            border-radius: 1.5rem;
            margin-top: 2rem;
            display: none;
        }

        .feature-badge {
            background: var(--success);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 2rem;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            margin: 0.5rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 style="text-align: center; color: var(--dark); margin-bottom: 2rem;">
            Premium Plans <i class="fas fa-crown"></i>
        </h1>

        <!-- Plans Section -->
        <div class="plans-container">
            <!-- Silver Plan -->
            <div class="plan-card">
                <i class="fas fa-medal plan-icon"></i>
                <h2>Silver Plan</h2>
                <div class="price">₹299</div>
                <ul class="features-list">
                    <li><i class="fas fa-check"></i> 20,000 Credits</li>
                    <li><i class="fas fa-check"></i> Basic Support</li>
                    <li><i class="fas fa-check"></i> Retailer ID</li>
                </ul>
                <button class="pay-button" data-plan="Silver">
                    Buy Now <i class="fas fa-arrow-right"></i>
                </button>
            </div>

            <!-- Gold Plan -->
            <div class="plan-card">
                <i class="fas fa-trophy plan-icon"></i>
                <h2>Gold Plan</h2>
                <div class="price">₹499</div>
                <ul class="features-list">
                    <li><i class="fas fa-check"></i> 50,000 Credits</li>
                    <li><i class="fas fa-check"></i> Priority Support</li>
                    <li><i class="fas fa-check"></i> Distributor ID</li>
                    <li><i class="fas fa-check"></i> Business Tools</li>
                </ul>
                <button class="pay-button" data-plan="Gold">
                    Buy Now <i class="fas fa-arrow-right"></i>
                </button>
            </div>

            <!-- Diamond Plan -->
            <div class="plan-card">
                <i class="fas fa-gem plan-icon"></i>
                <h2>Diamond Plan</h2>
                <div class="price">₹699</div>
                <ul class="features-list">
                    <li><i class="fas fa-check"></i> 1,00,000 Credits</li>
                    <li><i class="fas fa-check"></i> 24/7 VIP Support</li>
                    <li><i class="fas fa-check"></i> Enterprise ID</li>
                    <li><i class="fas fa-check"></i> Advanced Tools</li>
                    <li><i class="fas fa-check"></i> VIP Access</li>
                </ul>
                <button class="pay-button" data-plan="Diamond">
                    Buy Now <i class="fas fa-arrow-right"></i>
                </button>
            </div>
        </div>

        <!-- Payment Section -->
        <div class="payment-section">
            <h2><i class="fas fa-qrcode"></i> Scan to Pay</h2>
            <img id="qrCode" alt="Payment QR Code">
            <button class="payment-confirm" onclick="confirmPayment()">
                <i class="fas fa-check-circle"></i> I've Paid
            </button>
            <button class="back-button" onclick="showPlans()">
                <i class="fas fa-arrow-left"></i> Back to Plans
            </button>
        </div>

        <!-- Unlocked Features -->
        <div class="unlocked-features">
            <h2><i class="fas fa-unlock"></i> New Features Unlocked!</h2>
            <div id="unlockedFeaturesList"></div>
            <button class="back-button" onclick="showPlans()">
                <i class="fas fa-home"></i> Return to Plans
            </button>
        </div>
    </div>

    <script>
        let currentPlan = null;

        // Initialize button click handlers
        document.querySelectorAll('.pay-button').forEach(button => {
            button.addEventListener('click', function() {
                currentPlan = this.dataset.plan;
                showPaymentQR(currentPlan);
            });
        });

        function showPaymentQR(plan) {
            // Hide plans and show payment section
            document.querySelector('.plans-container').style.display = 'none';
            document.querySelector('.unlocked-features').style.display = 'none';
            
            // Generate QR code
            const amountMap = { Silver: 299, Gold: 499, Diamond: 699 };
            const qrData = `UPI:premium@payments|${amountMap[plan]}|${plan}Plan`;
            document.getElementById('qrCode').src = 
                `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(qrData)}&size=250x250`;
            
            document.querySelector('.payment-section').style.display = 'flex';
        }

        function confirmPayment() {
            if(currentPlan) {
                unlockFeatures(currentPlan);
                document.querySelector('.payment-section').style.display = 'none';
            }
        }

        function unlockFeatures(plan) {
            const features = {
                Silver: [
                    'Retailer ID Activated',
                    'Basic Support Access',
                    '20,000 Credits Added'
                ],
                Gold: [
                    'Distributor ID Activated',
                    'Priority Support (12hrs)',
                    'Business Toolkit Unlocked',
                    '50,000 Credits Added'
                ],
                Diamond: [
                    'Enterprise ID Activated',
                    '24/7 VIP Support',
                    'Advanced Business Tools',
                    'VIP Community Access',
                    '1,00,000 Credits Added'
                ]
            };

            const featuresList = document.getElementById('unlockedFeaturesList');
            featuresList.innerHTML = features[plan]
                .map(f => `<div class="feature-badge"><i class="fas fa-check"></i> ${f}</div>`)
                .join('');

            document.querySelector('.unlocked-features').style.display = 'block';
        }

        function showPlans() {
            document.querySelector('.plans-container').style.display = 'grid';
            document.querySelector('.payment-section').style.display = 'none';
            document.querySelector('.unlocked-features').style.display = 'none';
            currentPlan = null;
        }
    </script>
</body>
</html>