<?php
session_start();
include('header.php');
require_once('../includes/database.php');
?>

<!DOCTYPE html>
<html>
<head>
    <title>Certificate of Authorization</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background: aliceblue;
            margin: 0;
            padding: 20px;
        }
        
        .certificate-container {
            width: 800px;
            height: 600px;
            padding: 20px;
            text-align: center;
            border: 15px solid;
            border-image: linear-gradient(to bottom, #FF9933 33%, #FFFFFF 33% 66%, #138808 66%) 1;
            border-radius: 15px;
            background: aliceblue;
            position: relative;
            margin: 0 auto;
        }
        
        .certificate-inner {
            width: 750px;
            height: 550px;
            padding: 20px;
            text-align: center;
            border: 5px solid #1e40af;
            background: #fff;
            border-radius: 10px;
            position: relative;
        }
        
        .ashok-chakra {
            width: 80px;
            height: 80px;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'%3E%3Ccircle cx='50' cy='50' r='40' fill='%23000088'/%3E%3Ccircle cx='50' cy='50' r='35' fill='%23FFFFFF'/%3E%3Ccircle cx='50' cy='50' r='30' fill='%23000088'/%3E%3Cpath d='M50,20 L50,80 M20,50 L80,50 M35,35 L65,65 M35,65 L65,35' stroke='%23FFFFFF' stroke-width='3'/%3E%3Ccircle cx='50' cy='50' r='5' fill='%23FFFFFF'/%3E%3C/svg%3E");
            background-size: contain;
            margin: 0 auto;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            top: 20px;
            border: 2px solid #000080;
            border-radius: 50%;
            box-shadow: 0 0 5px rgba(0,0,0,0.3);
        }
        
        .signature, .title {
            float: left;
            border-top: 1px solid #000;
            width: 200px;
            text-align: center;
        }
        
        .certificate-title {
            font-size: 50px;
            font-weight: bold;
            color: #1e40af;
            margin-top: 30px;
        }
        
        .recipient-name {
            font-size: 30px;
            color: #1e40af;
            font-weight: bold;
        }
        
        .certificate-text {
            font-size: 25px;
            margin: 10px 0;
        }
        
        .signature-table {
            position: absolute;
            bottom: 50px;
            width: 100%;
        }
        
        @media print {
            @page {
                size: auto;
                margin: 0;
            }
            body {
                padding: 0;
                background: white;
            }
        }
    </style>
</head>
<body>

<div class="certificate-container">
    <div class="certificate-inner">
        <!-- Ashok Chakra -->
        <div class="ashok-chakra"></div>
        
        <!-- Organization Logo -->
        <div style="width:100%; margin-top: 30px;">
            <img  style="width: 130px; max-height: 100px; display: block; margin: 0 auto;">    
        </div>
        
        <!-- Certificate Title -->
        <div class="certificate-title">Certificate of Authorization</div>
        
        <!-- Certificate Content -->
        <div class="certificate-text"><i>This is to certify that Mr/Ms</i></div>
        <div class="recipient-name"><?php echo ucwords($udata['name']); ?></div>
        <div class="certificate-text"><i>Login ID: <?php echo ucwords($udata['phone']); ?></i></div>
        <div class="certificate-text"><i>Has Been Appointed as <?php echo ucwords($udata['usertype']); ?></i></div>
        <div class="certificate-text"><i>Issued Date</i></div>
        <div id="currentDate" style="font-style: italic;"></div>

        <script>
            var currentDateElement = document.getElementById('currentDate');
            var currentDate = new Date();
            var options = { day: '2-digit', month: 'long', year: 'numeric' };
            var formattedDate = currentDate.toLocaleString('en-us', options).toUpperCase();
            currentDateElement.innerHTML = formattedDate;
        </script>
        
        <!-- Signatures -->
        <div class="signature-table">
            <table style="width: 100%;">
                <tr>
                    <td style="width: 40%; text-align: center;">
                        <div style="border-top: 1px solid #000; width: 200px; margin: 0 auto;">
                            <p><b>Certificate Issued By</b></p>
                            <p><?php echo ucwords($ahkweb['name']); ?></p>
                        </div>
                    </td>
                    <td style="width: 20%;"></td>
                    <td style="width: 40%; text-align: center;">
                        <div style="border-top: 1px solid #000; width: 200px; margin: 0 auto;">
                            <p><b>Certificate Issued For</b></p>
                            <p><?php echo ucwords($udata['name']); ?></p>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>

<script>
    window.print();
</script>

</body>
</html>