<?php
session_start();
require_once "./utils/config.php";
require_once "./utils/common.php";
require_once "./dbcon.php";

// Check if user is logged in
if(!isset($_SESSION)) 
    { 
        session_start(); 
    } 
 if(isset($_SESSION['loggedin']) == true){
    $mail = $_SESSION['emailid'];
    $s_phone = $_SESSION['phone'];
 }

$user_id = $_SESSION['user_id'];
$error = '';
$success = '';

// Get current balance from usertable
$stmt = $con->prepare("SELECT walletamount FROM usertable WHERE userid = ?");
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$userData = $result->fetch_assoc();
$current_balance = $userData['walletamount'] ?? 0;

// Get recent transactions
$stmt = $con->prepare("
    SELECT transaction_id, amount, status, created_at 
    FROM balance_transactions 
    WHERE user_id = ? AND type = 'credit'
    ORDER BY created_at DESC LIMIT 5
");
$stmt->bind_param("s", $user_id);
$stmt->execute();
$recent_transactions = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Balance</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .balance-card {
            background: linear-gradient(45deg, #007bff, #0056b3);
            color: white;
            border-radius: 15px;
        }
        .transaction-card {
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .status-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.8rem;
        }
        .amount-input {
            font-size: 1.2rem;
            padding: 10px;
        }
        .quick-amount {
            cursor: pointer;
            transition: all 0.3s;
        }
        .quick-amount:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body class="bg-light">
    <div class="container mt-4">
        <div class="row">
            <div class="col-md-8 mx-auto">
                <!-- Current Balance Card -->
                <div class="card balance-card mb-4">
                    <div class="card-body p-4">
                        <div class="row align-items-center">
                            <div class="col">
                                <h6 class="mb-1">Current Balance</h6>
                                <h2 class="mb-0">₹<?php echo number_format($current_balance, 2); ?></h2>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Add Balance Form -->
                <div class="card transaction-card mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Add Money to Wallet</h5>
                    </div>
                    <div class="card-body">
                        <form action="process_balance.php" method="POST" id="addBalanceForm">
                            <div class="mb-4">
                                <label for="amount" class="form-label">Enter Amount (₹)</label>
                                <input type="number" class="form-control amount-input" id="amount" 
                                       name="amount" min="1" step="1" required 
                                       placeholder="Enter amount to add">
                            </div>

                            <!-- Quick Amount Selection -->
                            <div class="mb-4">
                                <label class="form-label">Quick Add</label>
                                <div class="row g-2">
                                    <div class="col-3">
                                        <div class="card quick-amount" onclick="setAmount(100)">
                                            <div class="card-body text-center">
                                                <h6 class="mb-0">₹100</h6>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="card quick-amount" onclick="setAmount(500)">
                                            <div class="card-body text-center">
                                                <h6 class="mb-0">₹500</h6>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="card quick-amount" onclick="setAmount(1000)">
                                            <div class="card-body text-center">
                                                <h6 class="mb-0">₹1000</h6>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="card quick-amount" onclick="setAmount(2000)">
                                            <div class="card-body text-center">
                                                <h6 class="mb-0">₹2000</h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary btn-lg w-100">Add Money</button>
                        </form>
                    </div>
                </div>

                <!-- Recent Transactions -->
                <div class="card transaction-card">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Recent Transactions</h5>
                    </div>
                    <div class="card-body p-0">
                        <?php if (empty($recent_transactions)): ?>
                            <div class="text-center p-4">
                                <p class="text-muted mb-0">No recent transactions</p>
                            </div>
                        <?php else: ?>
                            <div class="list-group list-group-flush">
                                <?php foreach ($recent_transactions as $transaction): ?>
                                    <div class="list-group-item">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <h6 class="mb-1">₹<?php echo number_format($transaction['amount'], 2); ?></h6>
                                                <small class="text-muted">
                                                    <?php echo date('d M Y, h:i A', strtotime($transaction['created_at'])); ?>
                                                </small>
                                            </div>
                                            <div>
                                                <span class="badge bg-<?php echo getStatusClass($transaction['status']); ?> status-badge">
                                                    <?php echo $transaction['status']; ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function setAmount(amount) {
            document.getElementById('amount').value = amount;
        }

        // Form validation
        document.getElementById('addBalanceForm').addEventListener('submit', function(e) {
            const amount = document.getElementById('amount').value;
            if (amount <= 0) {
                e.preventDefault();
                alert('Please enter a valid amount');
            }
        });
    </script>
</body>
</html>

<?php
function getStatusClass($status) {
    switch ($status) {
        case 'PAYMENT_SUCCESS':
            return 'success';
        case 'PAYMENT_INITIATED':
            return 'warning';
        case 'PAYMENT_PENDING':
            return 'info';
        default:
            return 'danger';
    }
}
?> 