<?php

function getTransactionID(){

    return rand(1111111111,99999999999);
}

function getUserBalance($userId, $con) {
    $stmt = $con->prepare("SELECT walletamount FROM usertable WHERE userid = ?");
    $stmt->bind_param("s", $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc()['walletamount'] ?? 0;
}

function updateUserBalance($userId, $amount, $type, $con) {
    try {
        $con->begin_transaction();

        if ($type === 'credit') {
            $stmt = $con->prepare("
                UPDATE usertable 
                SET walletamount = walletamount + ?
                WHERE userid = ?
            ");
        } else {
            $stmt = $con->prepare("
                UPDATE usertable 
                SET walletamount = walletamount - ?
                WHERE userid = ? AND walletamount >= ?
            ");
        }

        if ($type === 'credit') {
            $stmt->bind_param("ds", $amount, $userId);
        } else {
            $stmt->bind_param("dsd", $amount, $userId, $amount);
        }

        $result = $stmt->execute();
        
        if (!$result || $stmt->affected_rows === 0) {
            throw new Exception("Balance update failed");
        }

        $con->commit();
        return true;

    } catch (Exception $e) {
        $con->rollback();
        error_log("Balance update error: " . $e->getMessage());
        return false;
    }
}

?>