<?php
include('header.php');

// Check if QR data is received
if(isset($_GET['qr_data'])){
    $qr_data = mysqli_real_escape_string($conn, $_GET['qr_data']);
    
    // Parse QR data (format: PAYTO:userid:randomstring)
    $parts = explode(":", $qr_data);
    if(count($parts) >= 2 && $parts[0] == "PAYTO"){
        $receiver_id = $parts[1];
        
        // Get receiver details
        $receiver_query = mysqli_query($conn, "SELECT * FROM usertable WHERE userid='$receiver_id'");
        if(mysqli_num_rows($receiver_query) == 1){
            $receiver = mysqli_fetch_assoc($receiver_query);
            
            // Process payment if form submitted
            if(isset($_POST['make_payment'])){
                $amount = mysqli_real_escape_string($conn, $_POST['amount']);
                $sender_id = $_SESSION['userid'];
                
                // Check sender balance
                $sender_query = mysqli_query($conn, "SELECT * FROM usertable WHERE userid='$sender_id'");
                $sender = mysqli_fetch_assoc($sender_query);
                
                if($sender['walletamount'] >= $amount){
                    // Deduct from sender
                    mysqli_query($conn, "UPDATE usertable SET walletamount=walletamount-$amount WHERE userid='$sender_id'");
                    
                    // Add to receiver
                    mysqli_query($conn, "UPDATE usertable SET walletamount=walletamount+$amount WHERE userid='$receiver_id'");
                    
                    // Record transaction
                    $txn_id = "QR".time().rand(100,999);
                    mysqli_query($conn, "INSERT INTO qrtxn (txnid, username, amount, status) 
                                      VALUES ('$txn_id', '".$receiver['username']."', '$amount', 'completed')");
                    
                    // Success message
                    echo "<script>
                        $(function(){
                            Swal.fire(
                                'Payment Successful', 
                                '₹$amount has been transferred to ".$receiver['name']."',
                                'success'
                            ).then(() => {
                                window.location='index.php';
                            });
                        })
                    </script>";
                } else {
                    echo "<script>
                        $(function(){
                            Swal.fire(
                                'Insufficient Balance', 
                                'You don't have enough balance to make this payment',
                                'error'
                            )
                        })
                    </script>";
                }
            }
            
            // Show payment form
            ?>
            <div class="container-fluid">
                <div class="row page-header">
                    <div class="col-lg-6 align-self-center">
                        <h2>Make Payment via QR</h2>
                    </div>
                </div>

                <section class="main-content">
                    <div class="row">
                        <div class="col-md-6 offset-md-3">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Confirm Payment Details</h4>
                                </div>
                                <div class="card-body">
                                    <form action="" method="POST">
                                        <div class="form-group">
                                            <label>Receiver Name:</label>
                                            <input type="text" class="form-control" value="<?php echo $receiver['name']; ?>" readonly>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Your Current Balance:</label>
                                            <input type="text" class="form-control" value="₹<?php echo $sender['walletamount']; ?>" readonly>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Amount to Send:</label>
                                            <input type="number" name="amount" class="form-control" required min="1" max="<?php echo $sender['walletamount']; ?>">
                                        </div>
                                        
                                        <div class="text-center mt-4">
                                            <button type="submit" name="make_payment" class="btn btn-primary btn-lg">
                                                Confirm Payment
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <?php
        } else {
            echo "<script>
                $(function(){
                    Swal.fire(
                        'Invalid QR Code', 
                        'The scanned QR code is not valid',
                        'error'
                    ).then(() => {
                        window.location='index.php';
                    });
                })
            </script>";
        }
    } else {
        echo "<script>
            $(function(){
                Swal.fire(
                    'Invalid QR Format', 
                    'The scanned QR code is not in correct format',
                    'error'
                ).then(() => {
                    window.location='index.php';
                });
            })
        </script>";
    }
} else {
    header('Location: index.php');
}

?>