<?php
include('includes/config.php');
include('header.php');

if (isset($_POST['add_code'])) {
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $phone = mysqli_real_escape_string($conn, $_POST['phone']);
    $security_code = mysqli_real_escape_string($conn, $_POST['security_code']);
    $generated_time = date('Y-m-d H:i:s'); // Current time
    $is_used = 0; // Default value

    if (!empty($email) && !empty($phone) && !empty($security_code)) {
        // Check if email or phone already has a code
        $checkQuery = "SELECT * FROM security_codes WHERE email = '$email' AND phone = '$phone' AND is_used = 0";
        $result = mysqli_query($conn, $checkQuery);

        if (mysqli_num_rows($result) == 0) {
            // Insert into database
            $insertQuery = "INSERT INTO security_codes (email, phone, security_code, generated_time, is_used) 
                            VALUES ('$email', '$phone', '$security_code', '$generated_time', '$is_used')";
            if (mysqli_query($conn, $insertQuery)) {
                echo '<script>
                        Swal.fire({
                            title: "Success!",
                            text: "Security code added successfully!",
                            icon: "success",
                            confirmButtonText: "OK"
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.href = "add_security_code.php";
                            }
                        });
                      </script>';
            } else {
                echo '<script>
                        Swal.fire({
                            title: "Error!",
                            text: "Failed to add security code. Please try again.",
                            icon: "error",
                            confirmButtonText: "OK"
                        });
                      </script>';
            }
        } else {
            echo '<script>
                    Swal.fire({
                        title: "Error!",
                        text: "A security code already exists for this email or phone!",
                        icon: "error",
                        confirmButtonText: "OK"
                    });
                  </script>';
        }
    } else {
        echo '<script>
                Swal.fire({
                    title: "Error!",
                    text: "Please fill in all fields.",
                    icon: "error",
                    confirmButtonText: "OK"
                });
              </script>';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Security Code</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
    /* General body styling */
body {
    font-family: Arial, sans-serif;
    background-color: #f8f9fa;
    margin: 0;
    padding: 0;
}

/* Center the form container */
.container {
    max-width: 500px;
    background-color: #ffffff;
    margin: 50px auto;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
}

/* Form title */
h2 {
    text-align: center;
    color: #333333;
    margin-bottom: 20px;
}

/* Input fields styling */
.form-control {
    border-radius: 5px;
    border: 1px solid #ced4da;
    font-size: 16px;
    padding: 10px;
    transition: border-color 0.3s ease-in-out;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
}

/* Button styling */
.btn-primary {
    background-color: #007bff;
    border-color: #007bff;
    color: #ffffff;
    padding: 10px 15px;
    font-size: 16px;
    border-radius: 5px;
    width: 100%;
    transition: background-color 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
}

.btn-primary:hover {
    background-color: #0056b3;
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
}

/* Error or success messages */
.alert {
    font-size: 14px;
    margin-top: 10px;
    padding: 10px;
    border-radius: 5px;
}

.alert-success {
    color: #155724;
    background-color: #d4edda;
    border-color: #c3e6cb;
}

.alert-error {
    color: #721c24;
    background-color: #f8d7da;
    border-color: #f5c6cb;
}

/* Mobile responsive adjustments */
@media (max-width: 576px) {
    .container {
        margin: 20px;
        padding: 15px;
    }

    .btn-primary {
        font-size: 14px;
    }
}

    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center">Add Security Code for Users</h2>
        <form method="POST" action="">
            <div class="mb-3">
                <label for="email" class="form-label">User Email</label>
                <input type="email" class="form-control" id="email" name="email" placeholder="Enter user email" required>
            </div>
            <div class="mb-3">
                <label for="phone" class="form-label">User Phone</label>
                <input type="text" class="form-control" id="phone" name="phone" placeholder="Enter user phone" required>
            </div>
            <div class="mb-3">
                <label for="security_code" class="form-label">Security Code</label>
                <input type="text" class="form-control" id="security_code" name="security_code" placeholder="Enter security code" required>
            </div>
            <button type="submit" name="add_code" class="btn btn-primary">Add Security Code</button>
        </form>
    </div>
</body>
</html>