
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Maintenance Mode | ISK POWAR</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            text-align: center;
            background: linear-gradient(to right, #141E30, #243B55);
            color: #fff;
            margin: 0;
            padding: 0;
        }
        .container {
            padding: 50px;
        }
        h1 {
            font-size: 3rem;
            text-transform: uppercase;
            background: -webkit-linear-gradient(#ff00ff, #ff9900);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .countdown {
            font-size: 2rem;
            margin: 20px 0;
            font-weight: bold;
        }
        .donate {
            margin-top: 30px;
            font-size: 1.5rem;
        }
        .donate a {
            background: #ff9900;
            color: #fff;
            padding: 10px 20px;
            text-decoration: none;
            font-weight: bold;
            border-radius: 10px;
        }
        .chat-form {
            margin-top: 40px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            width: 300px;
            display: inline-block;
        }
        input, textarea {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: none;
            border-radius: 5px;
        }
        button {
            background: #ff00ff;
            color: #fff;
            padding: 10px;
            border: none;
            cursor: pointer;
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Maintenance Mode ISK POWAR</h1>
        <p>Sorry for the inconvenience, but we're performing some maintenance at the moment.</p>
        <div class="countdown" id="countdown"></div>
        <div class="donate">
            <p>If you like our work, support us by donating.</p>
            <a href="balance">Donate Now</a>
        </div>
        <div class="chat-form">
            <h2>Contact Us</h2>
            <form action="save_message.php" method="POST">
                <input type="text" name="name" placeholder="Your Name" required>
                <input type="email" name="email" placeholder="Your Email" required>
                <input type="text" name="mobile" placeholder="Your Mobile" required>
                <textarea name="message" placeholder="Your Message" required></textarea>
                <button type="submit">Send Message</button>
            </form>
        </div>
    </div>

    <script>
        // Countdown Timer Logic (Persistent Timer)
        const endDate = new Date("Mar 10, 2025 00:00:00").getTime();
        function updateCountdown() {
            const now = new Date().getTime();
            const remainingTime = endDate - now;
            
            const days = Math.floor(remainingTime / (1000 * 60 * 60 * 24));
            const hours = Math.floor((remainingTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);
            
            document.getElementById("countdown").innerHTML = `We will be back in ${days}d ${hours}h ${minutes}m ${seconds}s`;
            setTimeout(updateCountdown, 1000);
        }
        updateCountdown();
    </script>
</body>
</html>