<?php
session_start();

// Process donation form
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize inputs
    $name = htmlspecialchars($_POST['fullname']);
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $phone = preg_replace('/[^0-9]/', '', $_POST['phone']);
    $amount = filter_var($_POST['amount'], FILTER_SANITIZE_NUMBER_FLOAT);
    $payment_gateway = $_POST['payment_gateway'];

    // Validate inputs
    $errors = [];

    if (empty($name)) {
        $errors[] = "Name is required";
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format";
    }

    if (strlen($phone) != 10) {
        $errors[] = "Invalid phone number";
    }

    if ($amount < 100) {
        $errors[] = "Minimum donation is ₹100";
    }

    // If no errors, process donation
    if (empty($errors)) {
        // Create unique order ID
        $order_id = time() . rand(1000, 9999);

        // Store donation data in session
        $_SESSION['donation_data'] = [
            'name' => $name,
            'amount' => $amount,
            'email' => $email,
            'phone' => $phone,
            'order_id' => $order_id,
            'payment_gateway' => $payment_gateway
        ];

        if ($payment_gateway == 'movie4me') {
            // Movie4Me Gateway Integration
            $postData = http_build_query([
                'customer_mobile' => $phone,
                'user_token' => '3b5a65c28184fb285ab2751307c8908c',
                'amount' => $amount,
                'order_id' => $order_id,
                'redirect_url' => 'https://yourwebsite.com/success.php', // Updated to success.php
                'remark1' => $name,
                'remark2' => $email
            ]);

            $ch = curl_init('https://pay.movie4me.co.in/api/create-order');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);

            $response = curl_exec($ch);
            $result = json_decode($response, true);
            curl_close($ch);

            if (isset($result['status']) && $result['status'] === true) {
                header("Location: " . $result['result']['payment_url']);
                exit();
            } else {
                unset($_SESSION['donation_data']);
                $errors[] = "Failed to create donation order. Please try again.";
            }
        } 
        elseif ($payment_gateway == 'phonepe') {
            // PhonePe Gateway Integration
            $merchantId = "M22H0OIKR1JJY";
            $saltKey = "27a00c08-4229-4e38-998c-3cddcaa34e68";
            $saltIndex = 1;
            
            $callbackUrl = "https://yourwebsite.com/success.php"; // Updated to success.php
            $redirectUrl = "https://yourwebsite.com/success.php"; // Updated to success.php
            
            $data = [
                "merchantId" => $merchantId,
                "merchantTransactionId" => $order_id,
                "merchantUserId" => "USER_" . substr(md5($email), 0, 10),
                "amount" => $amount * 100,
                "redirectUrl" => $redirectUrl,
                "redirectMode" => "POST",
                "callbackUrl" => $callbackUrl,
                "mobileNumber" => $phone,
                "paymentInstrument" => [
                    "type" => "PAY_PAGE"
                ]
            ];
            
            $jsonPayload = json_encode($data);
            $payloadBase64 = base64_encode($jsonPayload);
            $xVerify = hash('sha256', $payloadBase64 . '/pg/v1/pay' . $saltKey) . '###' . $saltIndex;
            
            $phonepeUrl = "https://api.phonepe.com/apis/hermes/pg/v1/pay";
            
            $ch = curl_init($phonepeUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['request' => $payloadBase64]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'X-VERIFY: ' . $xVerify
            ]);
            
            $response = curl_exec($ch);
            $result = json_decode($response, true);
            curl_close($ch);
            
            if (isset($result['success']) && $result['success'] === true) {
                // Update session with PhonePe transaction details
                $_SESSION['donation_data']['transaction_id'] = $result['data']['merchantTransactionId'];
                header("Location: " . $result['data']['instrumentResponse']['redirectInfo']['url']);
                exit();
            } else {
                unset($_SESSION['donation_data']);
                $errors[] = "Failed to initiate PhonePe payment. Please try again.";
            }
        }
    }
}


?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support TechShiksha - Free Computer Education</title>
    <style>
        /* Existing styles from previous design */
        :root {
            --black: #000000;
            --white: #ffffff;
            --accent-pink: #ff00aa;
            --accent-green: #00ff9d;
            --accent-blue: #00a8ff;
            --accent-orange: #ff7b00;
            --border-radius: 16px;
            --box-shadow: 0 12px 24px rgba(0,0,0,0.2);
        }

        body {
            background-color: var(--black);
            color: var(--white);
            font-family: 'Poppins', sans-serif;
        }

        /* Navigation and header styles from previous design */
        
        .donation-container {
            max-width: 800px;
            margin: 100px auto;
            padding: 2rem;
        }

        .donation-card {
            background: rgba(0,0,0,0.7);
            border-radius: var(--border-radius);
            padding: 3rem;
            border: 2px solid;
            border-image: linear-gradient(45deg, var(--accent-pink), var(--accent-blue)) 1;
            backdrop-filter: blur(10px);
        }

        .donation-heading {
            text-align: center;
            margin-bottom: 2rem;
        }

        .donation-heading h1 {
            background: linear-gradient(90deg, var(--accent-green), var(--accent-orange));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-size: 2.5rem;
        }

        .amount-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 1rem;
            margin: 2rem 0;
        }

        .amount-option {
            background: rgba(255,255,255,0.05);
            border: 1px solid var(--accent-blue);
            padding: 1rem;
            border-radius: 8px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .amount-option:hover {
            background: var(--accent-blue);
            color: var(--black);
            transform: translateY(-3px);
        }

        .custom-amount {
            width: 100%;
            padding: 1rem;
            background: rgba(255,255,255,0.05);
            border: 1px solid var(--accent-green);
            color: var(--white);
            border-radius: 8px;
            margin-top: 1rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-input {
            width: 100%;
            padding: 1rem;
            background: rgba(255,255,255,0.05);
            border: 1px solid var(--accent-pink);
            color: var(--white);
            border-radius: 8px;
        }

        .donate-btn {
            width: 100%;
            padding: 1.5rem;
            background: linear-gradient(45deg, var(--accent-pink), var(--accent-blue));
            border: none;
            border-radius: 50px;
            color: var(--black);
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .donate-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(255,0,170,0.3);
        }

        .payment-methods {
            display: flex;
            gap: 1rem;
            justify-content: center;
            margin: 2rem 0;
        }

        .payment-option {
            background: rgba(255,255,255,0.05);
            padding: 1rem 2rem;
            border-radius: 8px;
            border: 1px solid var(--accent-green);
        }
    </style>
</head>
<body>
    <?php include('navbar.php'); // Your existing navigation ?>

    <div class="donation-container">
        <div class="donation-card">
            <div class="donation-heading">
                <h1>Support Free Tech Education</h1>
                <p>Your donation helps us empower underprivileged students</p>
            </div>

            <?php if(!empty($errors)): ?>
                <div class="error-message">
                    <?php foreach($errors as $error): ?>
                        <p><?= $error ?></p>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if(isset($success) && $success): ?>
                <div class="success-message">
                    <h3>Thank you for your donation, <?= $name ?>! 🎉</h3>
                    <p>We've sent a confirmation to <?= $email ?></p>
                </div>
            <?php else: ?>
                <form method="POST" action="donation.php">
                    <div class="amount-grid">
                        <div class="amount-option" data-amount="500">₹500</div>
                        <div class="amount-option" data-amount="1000">₹1000</div>
                        <div class="amount-option" data-amount="2000">₹2000</div>
                        <input type="number" name="amount" class="custom-amount" 
                               placeholder="Other Amount" min="100" required>
                    </div>

                    <div class="form-group">
                        <input type="text" name="fullname" class="form-input" 
                               placeholder="Full Name" required>
                    </div>

                    <div class="form-group">
                        <input type="email" name="email" class="form-input" 
                               placeholder="Email Address" required>
                    </div>

                    <div class="form-group">
                        <input type="tel" name="phone" class="form-input" 
                               placeholder="Mobile Number" pattern="[0-9]{10}" required>
                    </div>

                    <!-- Inside your form, replace payment-methods section with this: -->
                   <div class="payment-methods">
                        <div class="payment-option">
                   <input type="radio" name="payment_gateway" value="movie4me" id="movie4me" checked>
                   <label for="movie4me">Movie4Me Payment</label>
                   </div>
                  <div class="payment-option">
                  <input type="radio" name="payment_gateway" value="phonepe" id="phonepe">
                  <label for="phonepe">PhonePe</label>
                 </div>
                  </div>

                    <button type="submit" class="donate-btn">
                        Donate Now
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <?php include('footer.php'); // Your existing footer ?>

    <script>
        // Amount Selection
        document.querySelectorAll('.amount-option').forEach(button => {
            button.addEventListener('click', () => {
                const amount = button.getAttribute('data-amount');
                document.querySelector('.custom-amount').value = amount;
                document.querySelectorAll('.amount-option').forEach(btn => {
                    btn.style.background = '';
                    btn.style.color = '';
                });
                button.style.background = 'var(--accent-blue)';
                button.style.color = 'var(--black)';
            });
        });

        // Form Validation
        document.querySelector('form').addEventListener('submit', (e) => {
            const amount = document.querySelector('[name="amount"]').value;
            if(amount < 100) {
                alert('Minimum donation amount is ₹100');
                e.preventDefault();
            }
        });
    </script>
</body>
</html>