<?php
// success.php
session_start();

// Check if donation data exists (you can pass via session or GET parameters)
if(isset($_SESSION['donation_data'])) {
    $donation = $_SESSION['donation_data'];
    $name = htmlspecialchars($donation['name'] ?? '');
    $amount = htmlspecialchars($donation['amount'] ?? '');
    $email = htmlspecialchars($donation['email'] ?? '');
    $transaction_id = htmlspecialchars($donation['transaction_id'] ?? '');
} else {
    // Redirect if accessed directly without donation
    header("Location: donation.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thank You for Your Donation</title>
    <style>
        :root {
            --black: #000000;
            --white: #ffffff;
            --accent-pink: #ff00aa;
            --accent-green: #00ff9d;
            --accent-blue: #00a8ff;
            --accent-orange: #ff7b00;
            --border-radius: 16px;
            --box-shadow: 0 12px 24px rgba(0,0,0,0.2);
        }

        body {
            background-color: var(--black);
            color: var(--white);
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .success-container {
            max-width: 800px;
            margin: 50px auto;
            padding: 2rem;
            flex: 1;
        }

        .success-card {
            background: rgba(0,0,0,0.7);
            border-radius: var(--border-radius);
            padding: 3rem;
            border: 2px solid;
            border-image: linear-gradient(45deg, var(--accent-pink), var(--accent-blue)) 1;
            backdrop-filter: blur(10px);
            text-align: center;
        }

        .success-heading h1 {
            background: linear-gradient(90deg, var(--accent-green), var(--accent-orange));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-size: 2.5rem;
            margin-bottom: 1rem;
        }

        .success-icon {
            font-size: 5rem;
            margin: 1rem 0;
            background: linear-gradient(45deg, var(--accent-pink), var(--accent-blue));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .donation-details {
            background: rgba(255,255,255,0.05);
            border-radius: var(--border-radius);
            padding: 1.5rem;
            margin: 2rem 0;
            text-align: left;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.5rem;
            padding-bottom: 0.5rem;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .detail-label {
            color: var(--accent-green);
            font-weight: bold;
        }

        .home-btn {
            display: inline-block;
            padding: 1rem 2rem;
            background: linear-gradient(45deg, var(--accent-pink), var(--accent-blue));
            border: none;
            border-radius: 50px;
            color: var(--black);
            font-weight: bold;
            text-decoration: none;
            margin-top: 1rem;
            transition: all 0.3s ease;
        }

        .home-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(255,0,170,0.3);
        }

        .confirmation-note {
            margin-top: 2rem;
            font-size: 0.9rem;
            color: rgba(255,255,255,0.7);
        }

        footer {
            text-align: center;
            padding: 1rem;
            background: rgba(0,0,0,0.5);
            margin-top: auto;
        }
    </style>
</head>
<body>
    <?php include('navbar.php'); ?>

    <div class="success-container">
        <div class="success-card">
            <div class="success-heading">
                <h1>Thank You for Your Support!</h1>
                <p>Your donation helps us empower underprivileged students</p>
            </div>

            <div class="success-icon">✓</div>

            <div class="donation-details">
                <div class="detail-row">
                    <span class="detail-label">Name:</span>
                    <span><?php echo $name; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Amount:</span>
                    <span>₹<?php echo number_format($amount, 2); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Transaction ID:</span>
                    <span><?php echo $transaction_id; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Email:</span>
                    <span><?php echo $email; ?></span>
                </div>
            </div>

            <p>We've sent a confirmation to <strong><?php echo $email; ?></strong></p>

            <a href="index.php" class="home-btn">Return to Home</a>

            <div class="confirmation-note">
                <p>If you have any questions about your donation, please contact us at <a href="mailto:support@techshiksha.com" style="color: var(--accent-blue);">support@techshiksha.com</a></p>
            </div>
        </div>
    </div>

    <?php include('footer.php'); ?>

    <script>
        // Confetti effect for celebration
        document.addEventListener('DOMContentLoaded', function() {
            // Simple confetti effect
            const colors = ['#ff00aa', '#00ff9d', '#00a8ff', '#ff7b00'];
            
            function createConfetti() {
                const confetti = document.createElement('div');
                confetti.style.position = 'fixed';
                confetti.style.width = '10px';
                confetti.style.height = '10px';
                confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                confetti.style.borderRadius = '50%';
                confetti.style.left = Math.random() * window.innerWidth + 'px';
                confetti.style.top = '-10px';
                confetti.style.zIndex = '9999';
                confetti.style.opacity = '0.8';
                
                document.body.appendChild(confetti);
                
                let position = -10;
                let rotation = Math.random() * 360;
                let speed = 2 + Math.random() * 3;
                
                const fall = setInterval(() => {
                    position += speed;
                    rotation += 2;
                    confetti.style.top = position + 'px';
                    confetti.style.transform = `rotate(${rotation}deg)`;
                    
                    if(position > window.innerHeight) {
                        clearInterval(fall);
                        confetti.remove();
                    }
                }, 20);
            }
            
            // Create confetti for 2 seconds
            const confettiInterval = setInterval(createConfetti, 50);
            setTimeout(() => {
                clearInterval(confettiInterval);
            }, 2000);
        });
    </script>
</body>
</html>