<?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        include('includes/config.php');
        require 'PHPMailer/src/PHPMailer.php';
        require 'PHPMailer/src/SMTP.php';
        require 'PHPMailer/src/Exception.php';

        $email = mysqli_real_escape_string($conn, $_POST['email']);
        
        // Check if user exists
        $stmt = $conn->prepare("SELECT * FROM usertable WHERE emailid = ? OR phone = ?");
        $stmt->bind_param("ss", $email, $email);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            $token = bin2hex(random_bytes(32));
            $expires = date("Y-m-d H:i:s", time() + 3600); // 1 hour expiration
            
            // Store token in database
            $updateStmt = $conn->prepare("UPDATE usertable SET reset_token = ?, reset_expires = ? WHERE emailid = ? OR phone = ?");
            $updateStmt->bind_param("ssss", $token, $expires, $email, $email);
            $updateStmt->execute();

            // Send email using SMTP
            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            try {
                // SMTP Configuration (Replace with your details)
                $mail->isSMTP();
                $mail->Host = 'mail.megabadshah.in';
                $mail->SMTPAuth = true;
                $mail->Username = 'no_reply@megabadshah.in';
                $mail->Password = 'Rahul@2025';
                $mail->SMTPSecure = 'ssl';
                $mail->Port = 465;

                // Email content
                $mail->setFrom('no_reply@megabadshah.in', 'THEME SEVA');
                $mail->addAddress($user['emailid']);
                $mail->isHTML(true);
                $mail->Subject = 'Password Reset Request';
                $resetLink = "https://megabadshah.in/reset-password.php?token=$token";
                $mail->Body = "Click here to reset your password: <a href='$resetLink'>$resetLink</a>";

                $mail->send();
                echo "<script>
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: 'Password reset link sent to your email!'
                    });
                </script>";
            } catch (Exception $e) {
                echo "<script>
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Mail could not be sent. Error: {$mail->ErrorInfo}'
                    });
                </script>";
            }
        } else {
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: 'No account found with that email/phone!'
                });
            </script>";
        }
    }
    ?>
    
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password</title>
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <style>
        /* Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        /* Background Animation */
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background: linear-gradient(-45deg, #ee7752, #e73c7e, #23a6d5, #23d5ab);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
        }

        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Main Container */
        .forgot-container {
            width: 100%;
            max-width: 500px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            padding: 40px;
            margin: 20px;
            opacity: 0;
            transform: translateY(20px);
            animation: fadeInUp 0.6s cubic-bezier(0.4, 0, 0.2, 1) forwards;
        }

        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Card Styling */
        .reset-card {
            width: 100%;
            transition: all 0.4s ease;
        }

        .reset-card:hover {
            transform: perspective(1000px) rotateX(1deg) rotateY(1deg);
        }

        /* Form Elements */
        h1 {
            text-align: center;
            margin-bottom: 30px;
            color: #333;
            font-weight: 600;
        }

        .reset-input-box {
            position: relative;
            margin: 30px 0;
        }

        .reset-input-box input {
            width: 100%;
            padding: 15px 50px 15px 20px;
            background: rgba(245, 245, 245, 0.9);
            border: 2px solid transparent;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        .reset-input-box input:focus {
            background: #fff;
            border-color: #7494ec;
            box-shadow: 0 0 15px rgba(116, 148, 236, 0.2);
            outline: none;
        }

        .reset-input-box i {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
            transition: 0.3s;
        }

        .reset-input-box input:focus ~ i {
            color: #7494ec;
            transform: translateY(-50%) scale(1.1);
        }

        /* Button Styling */
        .reset-btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(45deg, #7494ec, #9b7bec);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .reset-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(116, 148, 236, 0.3);
        }

        .reset-btn:active {
            transform: translateY(0);
        }

        /* Back Link */
        .back-link {
            display: inline-block;
            margin-top: 20px;
            color: #7494ec;
            text-decoration: none;
            transition: 0.3s;
            position: relative;
        }

        .back-link i {
            transition: 0.3s;
        }

        .back-link:hover {
            color: #5a7bd6;
        }

        .back-link:hover i {
            transform: translateX(-5px);
        }

        /* Responsive Adjustments */
        @media (max-width: 600px) {
            .forgot-container {
                padding: 30px 20px;
                margin: 15px;
            }
            
            h1 {
                font-size: 24px;
                margin-bottom: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="forgot-container">
        <div class="reset-card">
            <form id="forgotForm" method="POST">
                <h1>Reset Password</h1>
                <div class="reset-input-box">
                    <input type="text" id="resetEmail" name="email" placeholder="Email or Phone Number" required>
                    <i class='bx bxs-envelope'></i>
                </div>
                <button type="submit" class="reset-btn">Send Reset Link</button>
                <p class="text-center" style="margin-top: 20px;">
                    <a href="login.php" class="back-link">
                        <i class='bx bx-arrow-back'></i> Back to Login
                    </a>
                </p>
            </form>
        </div>
    </div>

    <
</body>
</html>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>